/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.modernui.view.UIManager;
import icyllis.modernui.widget.ScrollController;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.gui.ScrollPanel;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ScrollPanel.class})
public abstract class MixinScrollPanel
implements ScrollController.IListener {
    @Shadow(remap=false)
    protected float scrollDistance;
    @Shadow(remap=false)
    private boolean scrolling;
    @Shadow(remap=false)
    @Final
    protected int height;
    @Shadow(remap=false)
    @Final
    private Minecraft client;
    private final ScrollController mScrollController = new ScrollController(this);

    @Shadow(remap=false)
    protected abstract void applyScrollLimits();

    @Shadow(remap=false)
    protected abstract int getScrollAmount();

    @Shadow(remap=false)
    protected abstract int getMaxScroll();

    @Shadow(remap=false)
    protected abstract int getBarHeight();

    @Overwrite
    public boolean func_231043_a_(double mouseX, double mouseY, double scrollY) {
        if (scrollY != 0.0) {
            this.mScrollController.setMaxScroll(this.getMaxScroll());
            this.mScrollController.scrollBy(Math.round(-scrollY * (double)this.getScrollAmount()));
            return true;
        }
        return false;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void preRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        this.mScrollController.update(UIManager.getInstance().getDrawingTime());
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraftforge/client/gui/ScrollPanel;drawPanel(Lcom/mojang/blaze3d/vertex/PoseStack;IILcom/mojang/blaze3d/vertex/Tesselator;II)V")}, remap=false)
    private void preDrawPanel(MatrixStack matrix, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)((double)((int)((double)((float)((int)this.scrollDistance) - this.scrollDistance) * this.client.func_228018_at_().func_198100_s())) / this.client.func_228018_at_().func_198100_s()), (double)0.0);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraftforge/client/gui/ScrollPanel;drawPanel(Lcom/mojang/blaze3d/vertex/PoseStack;IILcom/mojang/blaze3d/vertex/Tesselator;II)V")}, remap=false)
    private void postDrawPanel(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        RenderSystem.popMatrix();
    }

    @Override
    public void onScrollAmountUpdated(ScrollController controller, float amount) {
        this.scrollDistance = amount;
        this.applyScrollLimits();
    }

    @Overwrite
    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            int maxScroll = this.height - this.getBarHeight();
            float moved = (float)(deltaY / (double)maxScroll);
            this.mScrollController.setMaxScroll(this.getMaxScroll());
            this.mScrollController.scrollBy((float)this.getMaxScroll() * moved);
            this.mScrollController.abortAnimation();
            return true;
        }
        return false;
    }
}

